/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.capability;

import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackCapability;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class CapabilityUtils {
    public static LazyOptional<ITravelersBackpack> getCapability(Player player) {
        return player.getCapability(TravelersBackpackCapability.TRAVELERS_BACKPACK_CAPABILITY, TravelersBackpackCapability.DEFAULT_FACING);
    }

    public static void synchronise(Player player) {
        CapabilityUtils.getCapability(player).ifPresent(ITravelersBackpack::synchronise);
    }

    public static void synchroniseToOthers(Player player) {
        CapabilityUtils.getCapability(player).ifPresent(i -> i.synchroniseToOthers(player));
    }

    public static boolean isWearingBackpack(Player player) {
        if (CapabilityUtils.getCapability(player).isPresent() && CapabilityUtils.getCapability(player).resolve().isPresent()) {
            return ((ITravelersBackpack)CapabilityUtils.getCapability(player).resolve().get()).hasWearable() && ((ITravelersBackpack)CapabilityUtils.getCapability(player).resolve().get()).getWearable().m_41720_() instanceof TravelersBackpackItem;
        }
        return false;
    }

    public static ItemStack getWearingBackpack(Player player) {
        return CapabilityUtils.isWearingBackpack(player) ? ((ITravelersBackpack)CapabilityUtils.getCapability(player).resolve().get()).getWearable() : ItemStack.f_41583_;
    }

    public static void equipBackpack(Player player, ItemStack stack) {
        if (CapabilityUtils.getCapability(player).isPresent() && !CapabilityUtils.isWearingBackpack(player)) {
            CapabilityUtils.getCapability(player).ifPresent(cap -> {
                cap.setWearable(stack);
                cap.setContents(stack);
                cap.synchronise();
                cap.synchroniseToOthers(player);
            });
            player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, (1.0f + (player.m_9236_().f_46441_.m_188501_() - player.m_9236_().f_46441_.m_188501_()) * 0.2f) * 0.7f);
        }
    }

    @Nullable
    public static TravelersBackpackContainer getBackpackInv(Player player) {
        if (CapabilityUtils.isWearingBackpack(player)) {
            return CapabilityUtils.getCapability(player).map(ITravelersBackpack::getContainer).orElse(null);
        }
        return null;
    }
}

